//  Listing 9.4. Zarzdzanie pamici przez kod klienta 
// zamiast po stronie obiektu - serwera

#include <iostream>
using namespace std;

struct Name 
{
char *contents; 		// publiczny wskanik do dynamicznej pamici
Name (char* name); 		// konstruktor konwertujcy
void show_name();      		// metoda
~Name();       			// destruktor eliminuje wycieki pamici
} ; 

Name::Name(char* name) 		// konstruktor konwersji
{ 
int len = strlen(name); 	// ilo znakw w nazwisku
contents = new char[len+1]; 	// przydzia pamici na stercie
if (contents == NULL) 		// operator new nie przydzieli pamici
{ cout << "Brak pamici.\n"; exit(1); } 	// wyjcie
strcpy(contents, name); 	// standardowe dziaanie
} 

void Name::show_name()
{ 
cout <<contents << "\n";       // wydruk wskazanego acucha znakw
}

Name::~Name() 			// implementacja destruktora
{ 
delete contents; 		// zwalniamy pami na stercie, ale nie usuwamy wskanika
} 

void Client()
{ 
Name n1("Jones"); 			// wywoanie konstruktora konwersji
Name *p=(Name*)malloc(sizeof(Name)); 	// bez wywoania konstruktora
p->contents = new char[strlen("Smith")+1]; 	// alokacja pamici
if (p->contents == NULL) 		// operator new nie przydzieli pamici
{ 
  cout << "Brak pamici.\n"; exit(1); 	// wyjcie 'awaryjne'
}
strcpy(p->contents, "Smith"); 		// 'new' zadziaa poprawnie
n1.show_name(); 
p->show_name(); 			// wykorzystujemy obiekty
delete p->contents; 			// zapobiegamy wyciekowi pamici
free (p); 				// uwaga na kolejno dziaa
} 			// usuwany jest p, wywoanie destruktora dla obiektu n1

int main() 		// przekazanie odpowiedzialnoci w d
{ 
  Client();
  return 0;
}
